#!/usr/bin/env python

from distutils.core import setup
import sys

PY2 = sys.version_info[0] == 2

with open('VERSION') as f:
    version_tag = f.read().strip()
with open("COPYING") as f:
    license = f.read()
with open("README") as f:
    long_description = f.read()

data_files = [ ('/etc/nepi', [ 'VERSION', 'COPYING', 'README' ] ) ]

### requirements - used by pip install
required_modules = [ ]
   # we are now using six for a portable code
required_modules.append('six')
   # ipaddr in py2 used to be a separate lib
   # within recent py3, it is now in standard library but named ipaddress
if PY2:
    required_modules.append('ipaddr')
   # this is required regardless of the python version
required_modules.append('networkx')
   # refrain from mentioning these ones that are not exactly crucial
   # and that have additional, non-python, dependencies
   # that can easily break the whole install
#required_modules.append('matplotlib')
#required_modules.append('pygraphviz')

setup(
    name             = "nepi",
    version          = version_tag,
    description      = "Network Experiment Management Framework",
    long_description = long_description,
    license          = license,
    author           = "Alina Quereilhac",
    author_email     = "alina.quereilhac@inria.fr",
    download_url     = "http://build.onelab.eu/nepi/nepi-{v}.tar.gz".format(v=version_tag),
    url              = "http://nepi.inria.fr/",
    platforms        = "Linux, OSX",
    data_files       = data_files,
    package_dir      = {"": "src"},
    packages         = [
        "nepi",
        "nepi.execution",
        "nepi.resources",
        "nepi.resources.all",
        "nepi.resources.linux",
        "nepi.resources.linux.ccn",
        "nepi.resources.linux.ns3",
        "nepi.resources.linux.ns3.ccn",
        "nepi.resources.linux.netns",
        "nepi.resources.netns",
        "nepi.resources.ns3",
        "nepi.resources.ns3.classes",
        "nepi.resources.omf",
        "nepi.resources.planetlab",
        "nepi.resources.planetlab.ns3",
        "nepi.resources.planetlab.openvswitch",
        "nepi.util",
        "nepi.util.parsers",
        "nepi.data",
        "nepi.data.processing",
        "nepi.data.processing.ccn",
        "nepi.data.processing.ping"],
    package_data     = {
        "nepi.resources.planetlab" : [ "scripts/*.py" ],
        "nepi.resources.linux" : [ "scripts/*.py" ],
        "nepi.resources.linux.ns3" : [ "dependencies/*.tar.gz" ]
    },
    install_requires = required_modules,
)
